/**
 * \file inc/CaloLevel1.h
 * \author Emiliano Mocchiutti
 */
#ifndef CaloLevel1_h
#define CaloLevel1_h
//
// default position used only in CaloStrip for the moment
//
#define CTX 121.1
#define CTY 122.6
#define CTZ -263.1
//
#include <TObject.h>
#include <TClonesArray.h>
#include <TArrayI.h>
//
extern "C" int millim_(Int_t *, Float_t *);
struct shift {
  Float_t shift;
};
//

/**
 * \brief Calorimeter level1 class
 *
 * This class contains level1 calorimeter variables
 *
**/
class CaloLevel1 : public TObject {

 private:

 public:
    //
    Int_t istrip;      ///< total number of strip hit
    //
    // Number of strip with energy > emip and their value coded with view plane and strip number:
    // view x[y] plane PP strip SS with energy mmmm.iip = +[-] ( PP*10^6 + SS*10^4 + mmmm.iip )
    //
    TArrayI estrip; ///< MIP values for each strip with energy > emin coded with view plane and strip number. NOTICE: precision is limited to the 5 most significative ciphers
    //
    CaloLevel1* GetCaloLevel1(){return this;}; ///< returns pointer to this object
    //
    //
    Float_t GetEstrip(Int_t view, Int_t plane, Int_t strip); ///< returns saved MIP value for the indicated strip.
    Float_t DecodeEstrip(Int_t entry, Int_t &view, Int_t &plane, Int_t &strip); ///< returns saved MIP value for the entry number "entry" of the TArrayI.
    //
    void Clear();
    //
    CaloLevel1(); ///< Constructor.
    //
    ClassDef(CaloLevel1,1);
};

/**
 * \brief Calorimeter strip class, needed to perform operation on a strip level, for example to retrieve the position of the strips or to retrieve the closest strip to a cerain position
 *
 */
class CaloStrip : public TObject {

private:
    CaloLevel1 *c1;
    Float_t fE;
    Float_t fX;
    Float_t fY;
    Float_t fZ;
    Int_t fView;
    Int_t fPlane;
    Int_t fStrip;

public:
    //
    // METHODS
    //
    //
    CaloStrip(); ///< Default Constructor.
    //
    CaloStrip(CaloLevel1 *c1); ///< Constructor.
    //
    Float_t GetE(){return fE;};
    //
    Float_t GetX(){return fX;};
    Float_t GetY(){return fY;};
    Float_t GetZ(){return fZ;};
    //
    Int_t GetView(){return (fView-1);};
    Int_t GetPlane(){return (fPlane-1);};
    Int_t GetStrip(){return (fStrip-1);};
    //
    void Set(Int_t view, Int_t plane, Int_t strip);
    void Set(Float_t X, Float_t Y, Float_t Z);
    //
    void Clear(); ///< clear variables
    //
    CaloStrip* GetCaloStrip(){return this;}; ///< returns pointer to this object
    //
    ClassDef(CaloStrip,1);
    //
};

#endif
